package com.biz.crm.sfa.admin.web.report.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 拜访完成进度dto
 * @author: rentao
 * @date: 2022/7/6 14:30
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "VisitCompletionProgressPageDto", description = "拜访完成进度dto")
public class VisitCompletionProgressPageDto extends TenantDto {

  @ApiModelProperty("拜访日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date visitDate;

  @ApiModelProperty("拜访年月")
  private String visitYearMonth;

  @ApiModelProperty("人员姓名")
  private String realName;

  @ApiModelProperty("职位编码")
  private String postName;
}
