package com.biz.crm.sfa.admin.web.report.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 加班汇总报表分页dto
 * @author jerry7
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "WorkOverTimePageDto", description = "加班汇总报表分页Dto")
public class WorkOverTimePageDto extends TenantDto {

  /**
   * 开始时间
   */
  @ApiModelProperty(value = "开始时间")
  private String startTime;

  /**
   * 结束时间
   */
  @ApiModelProperty(value = "结束时间")
  private String endTime;

  /**
   * 用户账号
   */
  @ApiModelProperty(value = "用户账号")
  private String userName;

  /**
   * 用户姓名
   */
  @ApiModelProperty(value = "用户姓名")
  private String userRealName;

  /**
   * 职位名称
   */
  @ApiModelProperty(value = "职位名称")
  private String positionName;

  /**
   * 组织名称
   */
  @ApiModelProperty(value = "组织名称")
  private String orgName;

  /**
   * 上级组织名称
   */
  @ApiModelProperty(value = "上级组织名称")
  private String parentOrgName;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String processStatus;

  /**
   * 流程业务模块编码
   */
  @ApiModelProperty("流程业务模块编码")
  private String businessCode;

}
