package com.biz.crm.sfa.admin.web.report.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 拜访统计类型
 * @author: rentao
 * @date: 2022/7/7 11:01
 */
@Getter
@AllArgsConstructor
public enum  VisitStatisticalType {
  /**
   * 上下班打卡
   */
  DAY("day", "day", "日", "1"),
  /**
   * 上班签到
   */
  MONTH("month", "month", "月", "2"),

  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过字典编码获取枚举值
   *
   * @param dictCode 字典编码
   * @return 取枚举值
   */
  public static VisitStatisticalType getByDictCode(String dictCode) {
    VisitStatisticalType result = null;
    for (VisitStatisticalType type : VisitStatisticalType.values()) {
      if (type.getDictCode().equals(dictCode)) {
        result = type;
        break;
      }
    }
    return result;
  }
}
