package com.biz.crm.sfa.admin.web.report.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveApplySummaryDto;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveVo;
import org.apache.ibatis.annotations.Param;

/**
 * 请假申请mapper
 *
 * @author jerry7
 */
public interface LeaveVoMapper {
  /**
   * 列表
   *
   * @param page 分页参数
   * @param dto  查询参数
   * @return 请假申请分页列表
   */
  Page<SfaLeaveVo> findByConditions(Page<SfaLeaveVo> page, @Param("vo") SfaLeaveListDto dto);

  /**
   * 请假申请汇总
   *
   * @param page 分页信息
   * @param dto  请假汇总查询
   * @return 请假申请汇总
   */
  Page<SfaLeaveVo> findSummaryByConditions(Page<SfaLeaveVo> page, @Param("vo") SfaLeaveApplySummaryDto dto);

}
