package com.biz.crm.sfa.admin.web.report.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyVo;
import org.apache.ibatis.annotations.Param;

/**
 * 出差申请Vo的mybatis-plus接口类
 *
 * @author ning.zhang
 * @date 2022-05-31 15:20:31
 */
public interface TravelApplyVoMapper {

  /**
   * 出差申请分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<TravelApplyVo> 出差申请分页信息
   */
  Page<TravelApplyVo> findByConditions(Page<TravelApplyVo> page, @Param("dto") TravelApplyPageDto dto);

  /**
   * 出差申请明细分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<TravelApplyDetailVo> 出差申请分页信息
   */
  Page<TravelApplyDetailVo> findDetailByConditions(Page<TravelApplyDetailVo> page, @Param("dto") TravelApplyPageDto dto);

}

