package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.mapper.AttendanceFillApplyVoMapper;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillApplyPageDto;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 补打考勤申请Vo的数据库访问类
 *
 * @author ning.zhang
 * @date 2022-05-25 10:40:08
 */
@Component
public class AttendanceFillApplyVoRepository {

  @Autowired
  private AttendanceFillApplyVoMapper attendanceFillApplyVoMapper;

  /**
   * 补打卡申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceFillApplyVo> 补打卡申请分页信息
   */
  public Page<AttendanceFillApplyVo> findByConditions(Pageable pageable, AttendanceFillApplyPageDto dto) {
    Page<AttendanceFillApplyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.attendanceFillApplyVoMapper.findByConditions(page, dto);
  }
}
