package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.AttendanceHistoryPageDto;
import com.biz.crm.sfa.admin.web.report.mapper.AttendanceHistoryVoMapper;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceHistoryVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * AttendanceHistoryVoRepository
 *
 * @author ning.zhang
 * @date 2022/5/26
 */
@Component
public class AttendanceHistoryVoRepository {

  @Autowired
  private AttendanceHistoryVoMapper attendanceHistoryVoMapper;

  /**
   * 考勤历史分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceHistoryVo> 考勤历史分页信息
   */
  public Page<AttendanceHistoryVo> findByConditions(Pageable pageable, AttendanceHistoryPageDto dto) {
    Page<AttendanceHistoryVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.attendanceHistoryVoMapper.findByConditions(page, dto);
  }
}
