package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.AttendanceRecordMonthPageDto;
import com.biz.crm.sfa.admin.web.report.mapper.AttendanceRecordMonthVoMapper;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceRecordMonthVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @description: 月度考勤 Repository
 * @author: rentao
 * @date: 2022/7/4 15:34
 */
@Component
public class AttendanceRecordMonthVoRepository {


  @Autowired
  private AttendanceRecordMonthVoMapper attendanceRecordMonthVoMapper;

  /**
   * 考勤历史分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceHistoryVo> 考勤历史分页信息
   */
  public Page<AttendanceRecordMonthVo> findByConditions(Pageable pageable, AttendanceRecordMonthPageDto dto) {
    Page<AttendanceRecordMonthVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.attendanceRecordMonthVoMapper.findByConditions(page, dto);
  }
}
