package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.mapper.BusinessDynamicVoMapper;
import com.biz.crm.sfa.admin.web.report.vo.BusinessDynamicVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 业务动态相关sql操作
 *
 * @author songjingen
 * @date 2022/7/5
 */
@Component
public class BusinessDynamicVoRepository {

  @Autowired
  private BusinessDynamicVoMapper businessDynamicVoMapper;

  /**
   * 根据客户类型和客户编码查询数据
   *
   * @param pageable   分页信息
   * @param clientCode 客户编码
   * @param clientType 客户类型
   * @return
   */
  public Page<BusinessDynamicVo> findByClientCodeAndClientType(Pageable pageable, String clientCode, String clientType) {
    Page<BusinessDynamicVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.businessDynamicVoMapper.findByClientCodeAndClientType(page, clientCode, clientType);
  }
}
