package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.HelpDefensePlanDetailPageDto;
import com.biz.crm.sfa.admin.web.report.mapper.HelpDefensePlanDetailVoMapper;
import com.biz.crm.sfa.admin.web.report.vo.HelpDefensePlanDetailReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 协访明细报表repository
 */
@Component
public class HelpDefensePlanDetailVoRepository {

  @Autowired
  private HelpDefensePlanDetailVoMapper helpDefensePlanDetailVoMapper;

  /**
   * 协访明细分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceHistoryVo> 协访明细分页信息
   */
  public Page<HelpDefensePlanDetailReportVo> findByConditions(Pageable pageable, HelpDefensePlanDetailPageDto dto) {
    Page<HelpDefensePlanDetailReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.helpDefensePlanDetailVoMapper.findByConditions(page, dto);
  }
}
