package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.mapper.LeaveVoMapper;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveApplySummaryDto;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;


/**
 * 请假申请数据访问层
 *
 * @author jerry7
 * @since 2022-05-06 11:15:39
 */
@Component
public class LeaveVoRepository {

  @Autowired
  private LeaveVoMapper leaveVoMapper;

  /**
   * 列表
   *
   * @param page        分页参数
   * @param sfaLeaveDto 分页请求
   * @return 分页请假数据
   */
  public Page<SfaLeaveVo> findByConditions(Pageable page, @Param("vo") SfaLeaveListDto sfaLeaveDto) {
    Page<SfaLeaveVo> leaveVoPage = new Page<>(page.getPageNumber(), page.getPageSize());
    return this.leaveVoMapper.findByConditions(leaveVoPage, sfaLeaveDto);
  }

  /**
   * 请假申请汇总
   *
   * @param page  分页信息
   * @param reqVo 请假汇总查询
   * @return 请假申请汇总
   */
  public Page<SfaLeaveVo> findSummaryByConditions(Pageable page, SfaLeaveApplySummaryDto reqVo) {
    Page<SfaLeaveVo> leaveVoPage = new Page<>(page.getPageNumber(), page.getPageSize());
    return this.leaveVoMapper.findSummaryByConditions(leaveVoPage, reqVo);
  }

}

