package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.mapper.OvertimeApplyVoMapper;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyPageDto;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 加班申请Vo的数据库访问类
 *
 * @author ning.zhang
 * @date 2022-05-30 11:05:25
 */
@Component
public class OvertimeApplyVoRepository {

  @Autowired
  private OvertimeApplyVoMapper overtimeApplyVoMapper;

  /**
   * 加班申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<OvertimeApplyVo> 加班申请分页信息
   */
  public Page<OvertimeApplyVo> findByConditions(Pageable pageable, OvertimeApplyPageDto dto) {
    Page<OvertimeApplyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.overtimeApplyVoMapper.findByConditions(page, dto);
  }
}
