package com.biz.crm.sfa.admin.web.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.mapper.TravelApplyVoMapper;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 出差申请Vo的数据库访问类
 *
 * @author ning.zhang
 * @date 2022-05-31 15:20:32
 */
@Component
public class TravelApplyVoRepository {

  @Autowired
  private TravelApplyVoMapper travelApplyVoMapper;

  /**
   * 出差申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TravelApplyVo> 出差申请分页信息
   */
  public Page<TravelApplyVo> findByConditions(Pageable pageable, TravelApplyPageDto dto) {
    Page<TravelApplyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.travelApplyVoMapper.findByConditions(page, dto);
  }

  /**
   * 出差申请明细分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TravelApplyDetailVo> 出差申请分页信息
   */
  public Page<TravelApplyDetailVo> findDetailByConditions(Pageable pageable, TravelApplyPageDto dto) {
    Page<TravelApplyDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.travelApplyVoMapper.findDetailByConditions(page, dto);
  }
}
