package com.biz.crm.sfa.admin.web.report.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.VisitPlanDetailReportDto;
import com.biz.crm.sfa.admin.web.report.mapper.VisitPlanDetailReportVoMapper;
import com.biz.crm.sfa.admin.web.report.vo.VisitPlanDetailReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 拜访明细报表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
@Component
public class VisitPlanDetailReportVoRepository {

  @Autowired
  private VisitPlanDetailReportVoMapper visitPlanDetailReportVoMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  public Page<VisitPlanDetailReportVo> findByConditions(Pageable pageable, VisitPlanDetailReportDto dto) {
    Page<VisitPlanDetailReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<VisitPlanDetailReportVo> pageList = this.visitPlanDetailReportVoMapper.findByConditions(page, dto);
    return pageList;
  }

}

