package com.biz.crm.sfa.admin.web.report.service;

import java.util.Map;

/**
 * 拜访分析service
 *
 * @author songjingen
 * @date 2022/7/5
 */
public interface VisitAnalysisVoService {

  /**
   * 拜访分析,根据客户查看近六个月的完成报表
   *
   * @param clientType 客户类型
   * @param clientCode 客户编码
   * @return 拜访分析, 根据客户查看近六个月的完成报表
   */
  Map<String, Long> findCompletedByClientTypeAndClientCode(String clientType, String clientCode);

  /**
   * 根据用户账号查看近六个月的完成报表
   *
   * @param userName 客户类型
   * @return 根据用户账号查看近六个月的完成报表
   */
  Map<String, Long> findCompletedByUserName(String userName);
}
