package com.biz.crm.sfa.admin.web.report.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.VisitCompletionProgressDetailDto;
import com.biz.crm.sfa.admin.web.report.dto.VisitCompletionProgressPageDto;
import com.biz.crm.sfa.admin.web.report.vo.VisitCompletionProgressDetailVo;
import com.biz.crm.sfa.admin.web.report.vo.VisitCompletionProgressVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @description: 拜访完成进度
 * @author: rentao
 * @date: 2022/7/6 14:33
 */
public interface VisitCompletionProgressVoService {

  /**
   * 后台-拜访完成进度 天
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<VisitCompletionProgressVo> 后台-拜访完成进度 天
   */
  Page<VisitCompletionProgressVo> findByConditions(Pageable pageable, VisitCompletionProgressPageDto dto);


  /**
   * 后台-拜访完成进度 月
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<VisitCompletionProgressVo> 后台-拜访完成进度 天
   */
  Page<VisitCompletionProgressVo> findMonthByConditions(Pageable pageable, VisitCompletionProgressPageDto dto);



  /**
   * 后台-轨迹
   *
   * @param visitCompletionProgressDetailDto      请求参数dto
   * @return List<VisitCompletionProgressVo>
   */
  List<VisitCompletionProgressDetailVo> findTrackByConditions(VisitCompletionProgressDetailDto visitCompletionProgressDetailDto);
}
