package com.biz.crm.sfa.admin.web.report.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.admin.web.report.dto.AttendanceHistoryPageDto;
import com.biz.crm.sfa.admin.web.report.repository.AttendanceHistoryVoRepository;
import com.biz.crm.sfa.admin.web.report.service.AttendanceHistoryVoService;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceHistoryVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 考勤历史Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/5/26
 */
@Slf4j
@Service
public class AttendanceHistoryVoServiceImpl implements AttendanceHistoryVoService {

  @Autowired
  private AttendanceHistoryVoRepository attendanceHistoryVoRepository;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private UserFeignVoService userFeignVoService;
  @Autowired
  private PositionVoService positionVoService;
  @Autowired
  private UserInfoVoService userInfoVoService;
  @Autowired
  private UserVoService userVoService;

  @Override
  public Page<AttendanceHistoryVo> findByConditions(Pageable pageable, AttendanceHistoryPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new AttendanceHistoryPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    dto.setUserNames(Sets.newHashSet(loginDetails.getAccount()));
    List<PositionVo> positionList = this.positionVoService.findByParentCode(loginDetails.getPostCode());
    if (!CollectionUtils.isEmpty(positionList)) {
      List<UserInfoVo> userList = this.userInfoVoService.findByPositionCodes(positionList.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet()));
      if (!CollectionUtils.isEmpty(userList)) {
        dto.getUserNames().addAll(userList.stream().map(UserInfoVo::getUserName).collect(Collectors.toList()));
      }
    }
    //如果搜索了关键字,需要查询关键字对应的用户集合
    if (StringUtils.isNotBlank(dto.getKeyWord())) {
      UserConditionDto userConditionDto = new UserConditionDto();
      userConditionDto.setFullName(dto.getKeyWord());
      dto.setKeyWordUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
    }
    Page<AttendanceHistoryVo> voPage = this.attendanceHistoryVoRepository.findByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(voPage.getRecords())) {
      return voPage;
    }
    Set<String> userNames = voPage.getRecords().stream().map(AttendanceHistoryVo::getUserName).collect(Collectors.toSet());
    List<UserVo> userList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
    Map<String, UserVo> userMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(userList)) {
      userMap = userList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
    }
    for (AttendanceHistoryVo historyVo : voPage.getRecords()) {
      UserVo userVo = userMap.getOrDefault(historyVo.getUserName(), new UserVo());
      historyVo.setUserRealName(userVo.getFullName());
    }
    return voPage;
  }
}
