package com.biz.crm.sfa.admin.web.report.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.repository.BusinessDynamicVoRepository;
import com.biz.crm.sfa.admin.web.report.service.BusinessDynamicVoService;
import com.biz.crm.sfa.admin.web.report.vo.BusinessDynamicVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author songjingen
 * @date 2022/7/5
 */
@Service
public class BusinessDynamicVoServiceImpl implements BusinessDynamicVoService {

  @Autowired
  private BusinessDynamicVoRepository businessDynamicVoRepository;

  @Override
  public Page<BusinessDynamicVo> findByClientCodeAndClientType(Pageable pageable, String clientCode, String clientType) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (StringUtils.isAnyBlank(clientCode, clientType)) {
      return new Page<>();
    }
    return this.businessDynamicVoRepository.findByClientCodeAndClientType(pageable, clientCode, clientType);
  }
}
