package com.biz.crm.sfa.admin.web.report.service.internal;

import com.biz.crm.sfa.admin.web.report.dto.VisitAnalysisDto;
import com.biz.crm.sfa.admin.web.report.repository.VisitAnalysisVoRepository;
import com.biz.crm.sfa.admin.web.report.service.VisitAnalysisVoService;
import com.biz.crm.sfa.admin.web.report.vo.VisitAnalysisVo;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拜访分析service实现类
 *
 * @author songjingen
 * @date 2022/7/5
 */
@Service
public class VisitAnalysisVoServiceImpl implements VisitAnalysisVoService {

  @Autowired
  private VisitAnalysisVoRepository visitAnalysisVoRepository;

  @Override
  public Map<String, Long> findCompletedByClientTypeAndClientCode(String clientType, String clientCode) {
    if (StringUtils.isAnyBlank(clientType, clientCode)) {
      return null;
    }
    //获取近六月的第一天
    Date end = new Date();
    Date start = DateUtils.addMonths(DateUtils.ceiling(end, Calendar.MONTH), -6);
    VisitAnalysisDto dto = new VisitAnalysisDto();
    dto.setStatus(VisitStatusEnum.VISIT_TO_COMPLETE.getDictCode());
    dto.setVisitDateStart(DateFormatUtils.format(start, "yyyy-MM-dd"));
    dto.setVisitDateEnd(DateFormatUtils.format(end, "yyyy-MM-dd"));
    dto.setClientCode(clientCode);
    dto.setClientType(clientType);
    List<VisitAnalysisVo> byVisitAnalysisDto = this.visitAnalysisVoRepository.findByVisitAnalysisDto(dto);
    if (CollectionUtils.isEmpty(byVisitAnalysisDto)) {
      return null;
    }
    Map<String, Long> map = byVisitAnalysisDto.stream().filter(visitAnalysisVo -> visitAnalysisVo.getVisitDate() != null)
        .collect(Collectors.groupingBy(visitAnalysisVo -> DateFormatUtils.format(visitAnalysisVo.getVisitDate(), "yyyy-MM"), Collectors.summingLong(value -> value.getVisitCount())));
    return map;
  }

  @Override
  public Map<String, Long> findCompletedByUserName(String userName) {
    if (StringUtils.isBlank(userName)) {
      return null;
    }
    //获取近六月的第一天
    Date end = new Date();
    Date start = DateUtils.addMonths(DateUtils.ceiling(end, Calendar.MONTH), -6);
    VisitAnalysisDto dto = new VisitAnalysisDto();
    dto.setStatus(VisitStatusEnum.VISIT_TO_COMPLETE.getDictCode());
    dto.setVisitDateStart(DateFormatUtils.format(start, "yyyy-MM-dd"));
    dto.setVisitDateEnd(DateFormatUtils.format(end, "yyyy-MM-dd"));
    dto.setUserName(userName);
    List<VisitAnalysisVo> byVisitAnalysisDto = this.visitAnalysisVoRepository.findByVisitAnalysisDto(dto);
    Map<String, Long> map = byVisitAnalysisDto.stream().filter(visitAnalysisVo -> visitAnalysisVo.getVisitDate() != null)
        .collect(Collectors.groupingBy(visitAnalysisVo -> DateFormatUtils.format(visitAnalysisVo.getVisitDate(), "yyyy-MM"), Collectors.summingLong(value -> value.getVisitCount())));
    return map;
  }
}
