package com.biz.crm.sfa.admin.web.report.service.internal;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.VisitPlanDetailReportDto;
import com.biz.crm.sfa.admin.web.report.repository.VisitPlanDetailReportVoRepository;
import com.biz.crm.sfa.admin.web.report.service.VisitPlanDetailReportVoService;
import com.biz.crm.sfa.admin.web.report.vo.VisitPlanDetailReportVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 拜访计划明细vo实现类
 *
 * @author songjingen
 */
@Service
public class VisitPlanDetailReportVoServiceImpl implements VisitPlanDetailReportVoService {

  @Autowired
  private VisitPlanDetailReportVoRepository visitPlanDetailReportVoRepository;
  @Autowired(required = false)
  private List<ClientRouteStrategy> clientRouteStrategies;

  @Override
  public Page<VisitPlanDetailReportVo> findByConditions(Pageable pageable, VisitPlanDetailReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new VisitPlanDetailReportDto();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    if (dto.getVisitDateMonth() != null) {
      dto.setVisitDateMonthStr(DateFormatUtils.format(dto.getVisitDateMonth(), "yyyy-MM"));
    }
    Page<VisitPlanDetailReportVo> page = this.visitPlanDetailReportVoRepository.findByConditions(pageable, dto);
    List<VisitPlanDetailReportVo> records = page.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    this.buildVisitPlanDetailReportVos(records);
    return page;
  }

  /**
   * 组装VisitPlanDetailVo集合信息
   *
   * @param records
   */
  private void buildVisitPlanDetailReportVos(List<VisitPlanDetailReportVo> records) {
    //Map<clientRoute, Map<clientType, List<clientCode>>>
    Map<String, Map<String, List<String>>> clientMap = records.stream()
        .filter(visitPlanDetailReportVo -> StringUtils.isNotBlank(visitPlanDetailReportVo.getClientRoute()))
        .collect(
            Collectors.groupingBy(VisitPlanDetailReportVo::getClientRoute,
                Collectors.groupingBy(VisitPlanDetailReportVo::getClientType, Collectors.mapping(VisitPlanDetailReportVo::getClientCode, Collectors.toList())
                )));
    //判断客户维度策略
    if (CollectionUtils.isEmpty(clientRouteStrategies)) {
      return;
    }
    List<ClientRouteInfoVo> infoVos = new ArrayList<>();
    for (ClientRouteStrategy clientRouteStrategy : clientRouteStrategies) {
      Map<String, List<String>> listMap = clientMap.get(clientRouteStrategy.getKey());
      if (listMap != null) {
        List<ClientRouteInfoVo> terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
        List<ClientRouteInfoVo> dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
        infoVos.addAll(terminalVos);
        infoVos.addAll(dealerVos);
      }
    }
    Map<String, List<ClientRouteInfoVo>> infoVoHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(infoVos)) {
      infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith("_", o.getClientRoute(), o.getClientType(), o.getClientCode())));
    }
    for (VisitPlanDetailReportVo visitPlanDetailVo : records) {
      String key = StringUtils.joinWith("_", visitPlanDetailVo.getClientRoute(), visitPlanDetailVo.getClientType(), visitPlanDetailVo.getClientCode());
      List<ClientRouteInfoVo> vos = infoVoHashMap.get(key);
      if (!CollectionUtils.isEmpty(vos)) {
        ClientRouteInfoVo vo = vos.get(0);
        BeanUtil.copyProperties(vo, visitPlanDetailVo);
      }
    }
  }
}
