package com.biz.crm.sfa.admin.web.report.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.admin.web.report.dto.WorkOverTimePageDto;
import com.biz.crm.sfa.admin.web.report.repository.WorkOverTimeVoRepository;
import com.biz.crm.sfa.admin.web.report.service.WorkOverTimeVoService;
import com.biz.crm.sfa.admin.web.report.vo.OvertimeReportVo;
import com.biz.crm.sfa.business.overtime.sdk.constant.OvertimeConstant;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WorkOverTimeVoServiceImpl implements WorkOverTimeVoService {

  @Autowired
  private WorkOverTimeVoRepository workOverTimeVoRepository;

  @Override
  public Page<OvertimeReportVo> findByConditions(Pageable pageable, WorkOverTimePageDto dto) {
    dto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setBusinessCode(OvertimeConstant.OVERTIME_APPLY_PROCESS_FORM_TYPE);
    return this.workOverTimeVoRepository.findByConditions(pageable, dto);
  }
}
