package com.biz.crm.sfa.admin.web.report.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 考勤历史Vo
 *
 * @author ning.zhang
 * @date 2022/5/26
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceHistoryVo", description = "考勤历史Vo")
public class AttendanceHistoryVo extends UuidVo {

  private static final long serialVersionUID = -110650095398596909L;

  /**
   * 考勤时间
   */
  @ApiModelProperty("考勤时间")
  private String clockTime;

  /**
   * 考勤日期
   */
  @ApiModelProperty("考勤日期")
  private String clockDate;

  /**
   * 考勤人员账号
   */
  @ApiModelProperty("考勤人员账号")
  private String userName;

  /**
   * 考勤人员名字
   */
  @ApiModelProperty("考勤人员名字")
  private String userRealName;

  /**
   * 签到组名称
   */
  @ApiModelProperty("签到组名称")
  private String groupName;

  /**
   * 考勤状态(none:未考勤;ok:正常;be_late:迟到;leave_early:早退;error:异常)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus
   */
  @ApiModelProperty(value = "考勤状态(none:未考勤;ok:正常;be_late:迟到;leave_early:早退;error:异常)")
  private String clockStatus;

  /**
   * 考勤地点状态(ok:正常;ex:异常)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendancePlaceStatus
   */
  @ApiModelProperty("考勤地点状态(ok:正常;ex:异常)")
  private String clockPlaceStatus;

  /**
   * 考勤地址
   */
  @ApiModelProperty("考勤地址")
  private String clockPlace;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 考勤类型(free:自由签到;on_work:上班签到,off_work:下班签退)
   *
   * @see com.biz.crm.sfa.admin.web.report.enums.AttendanceHistoryClockType
   */
  @ApiModelProperty(value = "考勤类型(free:自由签到;on_work:上班签到,off_work:下班签退)")
  private String clockType;

}
