package com.biz.crm.sfa.admin.web.report.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 业务动态vo
 *
 * @author songjingen
 * @date 2022/7/5
 */
@Data
@ApiModel(value = "BusinessDynamicVo", description = "业务动态vo")
public class BusinessDynamicVo {

  /**
   * 父级编码
   */
  @ApiModelProperty("父级编码")
  private String parentCode;

  /**
   * 步骤编码
   */
  @ApiModelProperty("步骤编码")
  private String dynamicKey;

  /**
   * 表单编码
   */
  @ApiModelProperty("表单编码")
  private String dynamicFormCode;

  /**
   * 操作人员
   */
  @ApiModelProperty("操作人员")
  private String createName;

  /**
   * 完成步骤名称
   */
  @ApiModelProperty("完成步骤名称/完成工作")
  private String stepName;

  /**
   * 操作时间
   */
  @ApiModelProperty("操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private String createTime;

}
