package com.biz.crm.sfa.admin.web.report.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 协访计划明细报表
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HelpDefensePlanDetailReportVo", description = "协访计划明细报表")
public class HelpDefensePlanDetailReportVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 7022214277071025864L;
  /**
   * 协访计划编码
   */
  @ApiModelProperty("协访计划编码")
  private String helpPlanCode;


  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 协访状态
   * {@link HelpStatusEnum#getDictCode()}
   */
  @ApiModelProperty("协访状态")
  private String helpStatus;

  /**
   * 协访日期
   */
  @ApiModelProperty("协访日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date helpDate;

  /**
   * 被协访人员姓名
   */
  @ApiModelProperty("被协访人员账号")
  private String coverHelpUserName;

  /**
   * 被协访人员姓名
   */
  @ApiModelProperty("被协访人员姓名")
  private String coverHelpRealName;

  /**
   * 被协访人员职位编码
   */
  @ApiModelProperty("被协访人员职位编码")
  private String coverHelpPosCode;
  /**
   * 被协访人员职位名称
   */
  @ApiModelProperty("被协访人员职位名称")
  private String coverHelpPosName;
  /**
   * 被协访人员职位编码
   */
  @ApiModelProperty("被协访人员组织编码")
  private String coverHelpOrgCode;
  /**
   * 被协访人员职位名称
   */
  @ApiModelProperty("被协访人员组织名称")
  private String coverHelpOrgName;

  /**
   * 协访人员账号
   */
  @ApiModelProperty("协访人员账号")
  private String helpUserName;
  /**
   * 协访人员姓名
   */
  @ApiModelProperty("协访人员姓名")
  private String helpRealName;
  /**
   * 协访人员职位编码
   */
  @ApiModelProperty("协访人员职位编码")
  private String helpPosCode;
  /**
   * 协访人员职位名称
   */
  @ApiModelProperty("协访人员职位名称")
  private String helpPosName;
  /**
   * 协访人员职位编码
   */
  @ApiModelProperty("协访人员组织编码")
  private String helpOrgCode;
  /**
   * 协访人员职位名称
   */
  @ApiModelProperty("协访人员组织名称")
  private String helpOrgName;

  /**
   * 进店时间
   */
  @ApiModelProperty("进店时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date inStoreTime;

  /**
   * 进店地址
   */
  @ApiModelProperty("进店地址")
  private String inStoreAddress;

  /**
   * 离店时间
   */
  @ApiModelProperty("离店时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date outStoreTime;

  /**
   * 离店地址
   */
  @ApiModelProperty("离店地址")
  private String outStoreAddress;

  /**
   * 协访开始时间
   */
  @ApiModelProperty("协访开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date helpStartDate;

  /**
   * 协访结束时间
   */
  @ApiModelProperty("协访结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date helpEndDate;

  /**
   * 合格率
   */
  @ApiModelProperty("合格率")
  private String qualifiedRate;

}
