package com.biz.crm.sfa.admin.web.report.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 加班报表vo
 * @author jerry7
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OvertimeReportVo", description = "加班报表信息Vo")
public class OvertimeReportVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -7262877802300944536L;

  /**
   * 全部调休天数
   */
  @ApiModelProperty("全部调休天数")
  private BigDecimal allDays;

  /**
   * 已调休天数
   */
  @ApiModelProperty("已调休天数")
  private BigDecimal usedDays;

  /**
   * 可用调休天数
   */
  @ApiModelProperty("可用调休天数")
  private BigDecimal availableDays;

  /**
   * 节假日加班天数
   */
  @ApiModelProperty("节假日加班天数")
  private BigDecimal holidayDays;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String userName;

  /**
   * 人员名称
   */
  @ApiModelProperty("人员名称")
  private String userRealName;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String parentOrgName;
}
