package com.biz.crm.sfa.admin.web.report.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Entity;
import java.util.Date;

/**
 * 拜访明细报表vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@ApiModel(value = "VisitPlanDetailReportVo", description = "拜访明细报表vo")
public class VisitPlanDetailReportVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 7022214277071025864L;
  /**
   * 拜访计划编码
   */
  @ApiModelProperty("拜访计划编码")
  private String visitPlanCode;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String visitUserName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String visitRealName;

  /**
   * 人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  private String visitPostCode;

  /**
   * 人员职位名称
   */
  @ApiModelProperty("人员职位名称")
  private String visitPostName;

  /**
   * 人员所属组织编码
   */
  @ApiModelProperty("人员所属组织编码")
  private String visitOrgCode;

  /**
   * 人员所属组织名称
   */
  @ApiModelProperty("人员所属组织名称")
  private String visitOrgName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

  /**
   * 客户细类
   */
  @ApiModelProperty("客户细类")
  private String clientSubName;

  /**
   * 拜访状态
   * {@link VisitStatusEnum#getDictCode()}
   */
  @ApiModelProperty("拜访状态")
  private String visitStatus;

  /**
   * 拜访类型  临时拜访-计划外，计划拜访-计划内
   * <p>
   * {@link com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum#getDictCode()}
   */
  @ApiModelProperty("拜访类型")
  private String visitType;

  /**
   * 拜访日期
   */
  @ApiModelProperty("拜访日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date visitDate;

  /**
   * 进店时间
   */
  @ApiModelProperty("进店时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date inStoreTime;

  /**
   * 进店地址
   */
  @ApiModelProperty("进店地址")
  private String inStoreAddress;

  /**
   * 离店时间
   */
  @ApiModelProperty("离店时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date outStoreTime;

  /**
   * 离店地址
   */
  @ApiModelProperty("离店地址")
  private String outStoreAddress;


}
