package com.biz.crm.sfa.business.action.scheme.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeActionEntity;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeActionService;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 方案活动活动: SchemeAction: 方案活动活动管理
 *
 * @author ning.zhang
 * @date 2022/8/10
 */
@Slf4j
@RestController
@RequestMapping("/v1/schemeAction/schemeAction")
@Api(tags = "方案活动活动: SchemeAction: 方案活动活动管理")
public class SchemeActionController {

  @Autowired
  private SchemeActionService schemeActionService;

  /**
   * 新增方案活动信息
   *
   * @param dto 参数dto
   * @return 新增方案活动数据
   */
  @ApiOperation(value = "新增方案活动")
  @PostMapping("")
  public Result<SchemeActionEntity> create(@RequestBody SchemeActionDto dto) {
    try {
      return Result.ok(this.schemeActionService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新方案活动信息
   *
   * @param dto 参数dto
   * @return 更新后方案活动数据
   */
  @ApiOperation(value = "更新方案活动信息")
  @PatchMapping("")
  public Result<SchemeActionEntity> update(@RequestBody SchemeActionDto dto) {
    try {
      return Result.ok(this.schemeActionService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除方案活动
   *
   * @param ids 方案活动id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.schemeActionService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量关闭方案活动
   *
   * @param ids 方案活动id集合
   */
  @ApiOperation(value = "关闭")
  @PatchMapping("/closeBatch")
  public Result closeBatch(@RequestBody List<String> ids) {
    try {
      this.schemeActionService.closeBatch(ids);
      return Result.ok("关闭成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
