package com.biz.crm.sfa.business.action.scheme.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.service.SchemeActionVoService;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeActionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 方案活动活动: SchemeActionVo: 方案活动活动管理
 *
 * @author ning.zhang
 * @date 2022/8/10
 */
@Slf4j
@RestController
@RequestMapping("/v1/schemeAction/schemeAction")
@Api(tags = "方案活动活动: SchemeActionVo: 方案活动活动管理")
public class SchemeActionVoController {

  @Autowired
  private SchemeActionVoService schemeActionVoService;

  /**
   * 方案活动分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SchemeActionVo> 方案活动分页信息
   */
  @ApiOperation(value = "方案活动分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<SchemeActionVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                       @ApiParam(name = "SchemeActionPageDto", value = "分页Dto") SchemeActionPageDto dto) {
    try {
      return Result.ok(this.schemeActionVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过ID查询方案活动信息
   *
   * @param id ID
   * @return 方案活动信息
   */
  @ApiOperation(value = "通过ID查询方案活动信息")
  @GetMapping("/findById")
  public Result<SchemeActionVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.schemeActionVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
