package com.biz.crm.sfa.business.action.scheme.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.service.SchemeService;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 方案: Scheme: 方案管理
 *
 * @author ning.zhang
 * @date 2022/8/8
 */
@Slf4j
@RestController
@RequestMapping("/v1/scheme/scheme")
@Api(tags = "方案: Scheme: 方案管理")
public class SchemeController {

  @Autowired
  private SchemeService schemeService;

  /**
   * 新增方案信息
   *
   * @param dto 参数dto
   * @return 新增方案数据
   */
  @ApiOperation(value = "新增方案")
  @PostMapping("")
  public Result<SchemeEntity> create(@RequestBody SchemeDto dto) {
    try {
      return Result.ok(this.schemeService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新方案信息
   *
   * @param dto 参数dto
   * @return 更新后方案数据
   */
  @ApiOperation(value = "更新方案信息")
  @PatchMapping("")
  public Result<SchemeEntity> update(@RequestBody SchemeDto dto) {
    try {
      return Result.ok(this.schemeService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除方案
   *
   * @param ids 方案id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.schemeService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用方案
   *
   * @param ids 方案id集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result enableBatch(@RequestBody List<String> ids) {
    try {
      this.schemeService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用方案
   *
   * @param ids 方案id集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result disableBatch(@RequestBody List<String> ids) {
    try {
      this.schemeService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
