package com.biz.crm.sfa.business.action.scheme.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.action.scheme.sdk.service.SchemeTypeVoService;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 方案: SchemeTypeVo: 方案类型信息
 *
 * @author ning.zhang
 * @date 2022/8/8
 */
@Slf4j
@RestController
@RequestMapping("/v1/scheme/schemeType")
@Api(tags = "方案: SchemeTypeVo: 方案类型信息")
public class SchemeTypeVoController {

  @Autowired
  private SchemeTypeVoService schemeTypeVoService;

  /**
   * 获取所有方案类型列表
   *
   * @return 方案类型列表
   */
  @ApiOperation(value = "获取所有方案类型列表")
  @GetMapping("/findAll")
  public Result<List<SchemeTypeVo>> findAll() {
    try {
      return Result.ok(this.schemeTypeVoService.findAll());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
