package com.biz.crm.sfa.business.action.scheme.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionSelectPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemePageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.service.SchemeVoService;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 方案: Scheme: 方案管理
 *
 * @author ning.zhang
 * @date 2022/8/2
 */
@Slf4j
@RestController
@RequestMapping("/v1/scheme/scheme")
@Api(tags = "方案: SchemeVo: 方案管理")
public class SchemeVoController {

  @Autowired
  private SchemeVoService schemeVoService;

  /**
   * 方案分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 方案分页数据
   */
  @ApiOperation(value = "方案分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<SchemeVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                 @ApiParam(name = "SchemePageDto", value = "分页Dto") SchemePageDto dto) {
    try {
      return Result.ok(this.schemeVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 方案活动选择分页列表
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 方案分页数据
   */
  @ApiOperation(value = "方案活动选择分页列表")
  @GetMapping("/findBySchemeActionSelectPageDto")
  public Result<Page<SchemeVo>> findBySchemeActionSelectPageDto(@PageableDefault(50) Pageable pageable,
                                                 @ApiParam(name = "SchemeActionSelectPageDto", value = "分页Dto") SchemeActionSelectPageDto dto) {
    try {
      return Result.ok(this.schemeVoService.findBySchemeActionSelectPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过ID获取方案详细信息
   *
   * @param id 方案ID
   * @return 方案信息
   */
  @ApiOperation(value = "通过ID获取方案详细信息")
  @GetMapping("/findById")
  public Result<SchemeVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.schemeVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
