package com.biz.crm.sfa.business.action.scheme.local.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.sfa.business.action.scheme.sdk.enums.SchemeActionStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 方案活动实体类
 *
 * @author ning.zhang
 * @date 2022/8/9
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SchemeActionEntity", description = "方案活动实体类")
@Entity
@TableName("sfa_scheme_action")
@Table(name = "sfa_scheme_action", indexes = {
    @Index(name = "sfa_scheme_action_index1", columnList = "tenant_code"),
    @Index(name = "sfa_scheme_action_index2", columnList = "scheme_code"),
    @Index(name = "sfa_scheme_action_index3", columnList = "action_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_scheme_action", comment = "方案活动表")
public class SchemeActionEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 5207108009414125043L;

  /**
   * 方案编码
   */
  @ApiModelProperty("方案编码")
  @Column(name = "scheme_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '方案编码'")
  private String schemeCode;

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  @Column(name = "action_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动编码'")
  private String actionCode;

  /**
   * 活动名称
   */
  @ApiModelProperty("活动名称")
  @Column(name = "action_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动名称'")
  private String actionName;

  /**
   * 活动开始时间
   */
  @ApiModelProperty("活动开始时间")
  @Column(name = "action_start_date", columnDefinition = "datetime COMMENT '活动开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionStartDate;

  /**
   * 活动结束时间
   */
  @ApiModelProperty("活动结束时间")
  @Column(name = "action_end_date", columnDefinition = "datetime COMMENT '活动结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionEndDate;

  /**
   * 活动费用
   */
  @ApiModelProperty("活动费用")
  @Column(name = "action_cost", columnDefinition = "DECIMAL(20,4) COMMENT '活动费用'")
  private BigDecimal actionCost;

  /**
   * 单箱成本
   */
  @ApiModelProperty("单箱成本")
  @Column(name = "box_cost", columnDefinition = "DECIMAL(20,4) COMMENT '单箱成本'")
  private BigDecimal boxCost;

  /**
   * 计划销量
   */
  @ApiModelProperty("计划销量")
  @Column(name = "plan_sales", columnDefinition = "DECIMAL(20,4) COMMENT '计划销量'")
  private BigDecimal planSales;

  /**
   * 计划投入门店数量
   */
  @ApiModelProperty("计划投入门店数量")
  @Column(name = "plan_store_quantity", columnDefinition = "DECIMAL(20,4) COMMENT '计划投入门店数量'")
  private BigDecimal planStoreQuantity;

  /**
   * OA核销号
   */
  @ApiModelProperty("OA核销号")
  @Column(name = "oa_account", length = 128, columnDefinition = "VARCHAR(128) COMMENT 'OA核销号'")
  private String oaAccount;

  /**
   * 活动状态
   *
   * @see SchemeActionStatus
   */
  @ApiModelProperty("活动状态")
  @Column(name = "action_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动状态'")
  private String actionStatus;

  /**
   * 兑换方式类型key(实现方案活动兑换模块的key值信息)
   */
  @ApiModelProperty("兑换方式类型key(实现方案活动兑换模块的key值信息)")
  @Column(name = "exchange_type_key", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '方案类型key(实现普通方案模块的key值信息)'")
  private String exchangeTypeKey;

  /**
   * 方案活动兑换特定信息(实现方案活动的兑换特定信息)
   */
  @ApiModelProperty("方案活动兑换特定信息(实现方案活动的兑换特定信息)")
  @Transient
  @TableField(exist = false)
  private JSONObject exchangeJson;
}
