package com.biz.crm.sfa.business.action.scheme.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 陈列方案实体类
 *
 * @author ning.zhang
 * @date 2022/8/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SchemeDisplayEntity", description = "陈列方案实体类")
@Entity
@TableName("sfa_scheme_display")
@Table(name = "sfa_scheme_display", indexes = {
    @Index(name = "sfa_scheme_display_index1", columnList = "tenant_code"),
    @Index(name = "sfa_scheme_display_index2", columnList = "scheme_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_scheme_display", comment = "陈列方案表")
public class SchemeDisplayEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = -6643972404611269918L;

  /**
   * 方案编码
   */
  @ApiModelProperty("方案编码")
  @Column(name = "scheme_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '方案编码'")
  private String schemeCode;

  /**
   * 陈列商品
   */
  @ApiModelProperty("陈列商品")
  @Transient
  @TableField(exist = false)
  private List<SchemeDisplayProductEntity> productList;

  /**
   * 陈列要求
   */
  @ApiModelProperty("陈列要求")
  @Transient
  @TableField(exist = false)
  private List<SchemeDisplayRequireEntity> requireList;
}
