package com.biz.crm.sfa.business.action.scheme.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 陈列方案产品实体类
 *
 * @author ning.zhang
 * @date 2022/8/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SchemeDisplayProductEntity", description = "陈列方案产品实体类")
@Entity
@TableName("sfa_scheme_display_product")
@Table(name = "sfa_scheme_display_product", indexes = {
    @Index(name = "sfa_scheme_display_product_index1", columnList = "tenant_code"),
    @Index(name = "sfa_scheme_display_product_index2", columnList = "display_id"),
    @Index(name = "sfa_scheme_display_product_index3", columnList = "product_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_scheme_display_product", comment = "陈列方案产品表")
public class SchemeDisplayProductEntity extends TenantOpEntity {

  private static final long serialVersionUID = 4376451278594724460L;

  /**
   * 陈列方案ID
   */
  @ApiModelProperty("陈列方案ID")
  @Column(name = "display_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '陈列方案ID'")
  private String displayId;

  /**
   * 陈列产品编码
   */
  @ApiModelProperty("陈列产品编码")
  @Column(name = "product_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '陈列产品编码'")
  private String productCode;

  /**
   * 最低陈列面数
   */
  @ApiModelProperty("最低陈列面数")
  @Column(name = "surface_number", columnDefinition = "DECIMAL(9,2) COMMENT '最低陈列面数'")
  private BigDecimal surfaceNumber;
}
