package com.biz.crm.sfa.business.action.scheme.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 方案要求实体类
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SchemeDisplayRequireEntity", description = "方案要求实体类")
@Entity
@TableName("sfa_scheme_display_require")
@Table(name = "sfa_scheme_display_require", indexes = {
    @Index(name = "sfa_scheme_display_require_index1", columnList = "display_id"),
    @Index(name = "sfa_scheme_display_require_index2", columnList = "require_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_scheme_display_require", comment = "方案要求表")
public class SchemeDisplayRequireEntity extends TenantOpEntity {


  private static final long serialVersionUID = -8565101973860643071L;

  /**
   * 陈列方案ID
   */
  @ApiModelProperty("陈列方案ID")
  @Column(name = "display_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '陈列方案ID'")
  private String displayId;

  /**
   * 要求编码
   */
  @ApiModelProperty("要求编码")
  @Column(name = "require_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '要求编码'")
  private String requireCode;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  @Column(name = "sort_index", length = 4, columnDefinition = "int(4) COMMENT '排序(值越小越靠前)'")
  private Integer sortIndex;
}
