package com.biz.crm.sfa.business.action.scheme.local.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 方案实体类
 *
 * @author ning.zhang
 * @date 2022/8/5
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SchemeEntity", description = "方案实体类")
@Entity
@TableName("sfa_scheme")
@Table(name = "sfa_scheme", indexes = {
    @Index(name = "sfa_scheme_index1", columnList = "tenant_code"),
    @Index(name = "sfa_scheme_index2", columnList = "scheme_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_scheme", comment = "方案表")
public class SchemeEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = -482028997080057806L;

  /**
   * 方案编码
   */
  @ApiModelProperty("方案编码")
  @Column(name = "scheme_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '方案编码'")
  private String schemeCode;

  /**
   * 方案名称
   */
  @ApiModelProperty("方案名称")
  @Column(name = "scheme_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '方案名称'")
  private String schemeName;

  /**
   * 方案开始时间
   */
  @ApiModelProperty("方案开始时间")
  @Column(name = "scheme_start_date", columnDefinition = "datetime COMMENT '方案开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date schemeStartDate;

  /**
   * 方案结束时间
   */
  @ApiModelProperty("方案结束时间")
  @Column(name = "scheme_end_date", columnDefinition = "datetime COMMENT '方案结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date schemeEndDate;

  /**
   * 方案描述
   */
  @ApiModelProperty("方案描述")
  @Column(name = "scheme_description", columnDefinition = "varchar(255) COMMENT '方案描述'")
  private String schemeDescription;

  /**
   * 方案类型key(实现普通方案模块的key值信息)
   */
  @ApiModelProperty("方案类型key(实现普通方案模块的key值信息)")
  @Column(name = "type_key", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '方案类型key(实现普通方案模块的key值信息)'")
  private String typeKey;

  /**
   * 方案范围
   */
  @ApiModelProperty("方案范围")
  @Transient
  @TableField(exist = false)
  private List<SchemeScopeEntity> scopeList;

  /**
   * 方案文件范围
   */
  @ApiModelProperty("方案文件范围")
  @Transient
  @TableField(exist = false)
  private List<SchemeFileEntity> fileList;

  /**
   * 方案门店类型
   */
  @ApiModelProperty("方案门店类型")
  @Transient
  @TableField(exist = false)
  private List<SchemeStoreTypeEntity> storeTypeList;

  /**
   * 方案特定信息(实现方案的方案特定信息)
   */
  @ApiModelProperty("方案特定信息(实现方案的方案特定信息)")
  @Transient
  @TableField(exist = false)
  private JSONObject specificJson;
}
