package com.biz.crm.sfa.business.action.scheme.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 方案文件实体类
 *
 * @author ning.zhang
 * @date 2022/8/5
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SchemeFileEntity", description = "方案文件实体类")
@Entity
@TableName("sfa_scheme_file")
@Table(name = "sfa_scheme_file", indexes = {
    @Index(name = "sfa_scheme_file_index1", columnList = "tenant_code"),
    @Index(name = "sfa_scheme_file_index2", columnList = "scheme_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_scheme_file", comment = "方案文件表")
public class SchemeFileEntity extends FileEntity {

  private static final long serialVersionUID = -9023188114910421923L;

  /**
   * 方案ID
   */
  @ApiModelProperty("方案ID")
  @Column(name = "scheme_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '方案ID'")
  private String schemeId;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  @Column(name = "sort_index", length = 4, columnDefinition = "int(4) COMMENT '排序(值越小越靠前)'")
  private Integer sortIndex;
}
