package com.biz.crm.sfa.business.action.scheme.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.sfa.business.action.scheme.sdk.enums.SchemeScopeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 方案范围实体类
 *
 * @author ning.zhang
 * @date 2022/8/5
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SchemeScopeEntity", description = "方案范围实体类")
@Entity
@TableName("sfa_scheme_scope")
@Table(name = "sfa_scheme_scope", indexes = {
    @Index(name = "sfa_scheme_scope_index1", columnList = "tenant_code"),
    @Index(name = "sfa_scheme_scope_index2", columnList = "scheme_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_scheme_scope", comment = "方案范围表")
public class SchemeScopeEntity extends TenantOpEntity {

  private static final long serialVersionUID = -4699151004195821139L;

  /**
   * 方案ID
   */
  @ApiModelProperty("方案ID")
  @Column(name = "scheme_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '方案ID'")
  private String schemeId;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  @Column(name = "scope_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '范围编码'")
  private String scopeCode;

  /**
   * 范围类型(org:组织范围,position_level:职位级别范围)
   *
   * @see SchemeScopeType
   */
  @ApiModelProperty("范围类型(org:组织范围,position_level:职位级别范围)")
  @Column(name = "scope_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '范围类型(org:组织范围,position_level:职位级别范围)'")
  private String scopeType;
}
