package com.biz.crm.sfa.business.action.scheme.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.sfa.business.action.scheme.sdk.enums.SchemeScopeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 方案门店类型实体类
 *
 * @author ning.zhang
 * @date 2022/8/5
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SchemeStoreTypeEntity", description = "方案门店类型实体类")
@Entity
@TableName("sfa_scheme_store_type")
@Table(name = "sfa_scheme_store_type", indexes = {
    @Index(name = "sfa_scheme_store_type_index1", columnList = "tenant_code"),
    @Index(name = "sfa_scheme_store_type_index2", columnList = "scheme_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_scheme_store_type", comment = "方案门店类型表")
public class SchemeStoreTypeEntity extends TenantOpEntity {

  private static final long serialVersionUID = -3478079272140817388L;

  /**
   * 方案ID
   */
  @ApiModelProperty("方案ID")
  @Column(name = "scheme_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '方案ID'")
  private String schemeId;

  /**
   * 门店类型
   */
  @ApiModelProperty("门店类型")
  @Column(name = "store_type", length = 32, columnDefinition = "VARCHAR(64) COMMENT '门店类型'")
  private String storeType;
}
