package com.biz.crm.sfa.business.action.scheme.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeActionConditionModel;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeActionVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 方案活动Vo的mybatis-plus接口类
 *
 * @author ning.zhang
 * @date 2022/8/10
 */
public interface SchemeActionVoMapper {

  /**
   * 多条件查询方案活动列表
   *
   * @param model 条件model
   * @return 方案活动列表
   */
  List<SchemeActionVo> findBySchemeActionConditionModel(@Param("model") SchemeActionConditionModel model);

  /**
   * 方案活动分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<SchemeActionVo> 方案活动分页信息
   */
  Page<SchemeActionVo> findByConditions(Page<SchemeActionVo> page, @Param("dto") SchemeActionPageDto dto);

}
