package com.biz.crm.sfa.business.action.scheme.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeConditionModel;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionSelectPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemePageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 方案表的mybatis-plus接口类 {@link SchemeEntity}
 *
 * @author ning.zhang
 * @date 2022-08-05 14:32:17
 */
public interface SchemeMapper extends BaseMapper<SchemeEntity> {

  /**
   * 多条件查询方案列表
   *
   * @param model 条件model
   * @return 方案列表
   */
  List<SchemeEntity> findBySchemeConditionModel(@Param("model") SchemeConditionModel model);

  /**
   * 方案分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<SchemeEntity> 方案分页信息
   */
  Page<SchemeEntity> findByConditions(Page<SchemeEntity> page, @Param("dto") SchemePageDto dto);

  /**
   * 方案活动选择分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<SchemeEntity> 方案分页信息
   */
  Page<SchemeEntity> findBySchemeActionSelectPageDto(Page<SchemeEntity> page, @Param("dto") SchemeActionSelectPageDto dto);
}

