package com.biz.crm.sfa.business.action.scheme.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.Set;

/**
 * 陈列方案多条件model
 *
 * @author ning.zhang
 * @date 2022/8/8
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SchemeDisplayConditionModel", description = "陈列方案多条件model")
public class SchemeDisplayConditionModel {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  @ApiModelProperty("数据状态（删除状态）")
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @ApiModelProperty("数据业务状态（启用状态）")
  private String enableStatus;

  /**
   * 方案ID集合
   */
  @ApiModelProperty("方案ID集合")
  private Set<String> ids;

  /**
   * 方案编码集合
   */
  @ApiModelProperty("方案编码集合")
  private Set<String> schemeCodes;
}
