package com.biz.crm.sfa.business.action.scheme.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeActionEntity;
import com.biz.crm.sfa.business.action.scheme.local.mapper.SchemeActionMapper;
import com.biz.crm.sfa.business.action.scheme.sdk.enums.SchemeActionStatus;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 方案活动表的数据库访问类 {@link SchemeActionEntity}
 *
 * @author ning.zhang
 * @date 2022-08-09 17:17:18
 */
@Component
public class SchemeActionRepository extends ServiceImpl<SchemeActionMapper, SchemeActionEntity> {

  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(SchemeActionEntity::getId, ids)
        .set(SchemeActionEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新方案活动状态
   *
   * @param ids          ID集合
   * @param actionStatus 方案活动状态
   */
  public void updateActionStatusByIds(List<String> ids, SchemeActionStatus actionStatus) {
    this.lambdaUpdate()
        .in(SchemeActionEntity::getId, ids)
        .set(SchemeActionEntity::getActionStatus, actionStatus.getDictCode())
        .update();
  }
}
