package com.biz.crm.sfa.business.action.scheme.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.action.scheme.local.mapper.SchemeActionVoMapper;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeActionConditionModel;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.vo.SchemeActionVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 方案活动Vo的数据库访问类
 *
 * @author ning.zhang
 * @date 2022-08-09 17:17:18
 */
@Component
public class SchemeActionVoRepository {

  @Autowired
  private SchemeActionVoMapper schemeActionVoMapper;

  /**
   * 多条件查询方案活动列表
   *
   * @param model 条件model
   * @return 方案活动列表
   */
  public List<SchemeActionVo> findBySchemeActionConditionModel(SchemeActionConditionModel model) {
    return this.schemeActionVoMapper.findBySchemeActionConditionModel(model);
  }

  /**
   * 方案分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SchemeActionVo> 方案分页信息
   */
  public Page<SchemeActionVo> findByConditions(Pageable pageable, SchemeActionPageDto dto) {
    Page<SchemeActionVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.schemeActionVoMapper.findByConditions(page, dto);
  }
}
