package com.biz.crm.sfa.business.action.scheme.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayProductEntity;
import com.biz.crm.sfa.business.action.scheme.local.mapper.SchemeDisplayProductMapper;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 陈列方案产品表的数据库访问类 {@link SchemeDisplayProductEntity}
 *
 * @author ning.zhang
 * @date 2022-08-08 14:11:50
 */
@Component
public class SchemeDisplayProductRepository extends ServiceImpl<SchemeDisplayProductMapper, SchemeDisplayProductEntity> {

  /**
   * 通过陈列方案ID删除数据
   *
   * @param displayIds 陈列方案ID
   */
  public void deleteByDisplayIds(Set<String> displayIds) {
    this.lambdaUpdate()
        .in(SchemeDisplayProductEntity::getDisplayId, displayIds)
        .remove();
  }
}
