package com.biz.crm.sfa.business.action.scheme.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayEntity;
import com.biz.crm.sfa.business.action.scheme.local.mapper.SchemeDisplayMapper;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeDisplayConditionModel;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 陈列方案表的数据库访问类 {@link SchemeDisplayEntity}
 *
 * @author ning.zhang
 * @date 2022-08-08 14:11:49
 */
@Component
public class SchemeDisplayRepository extends ServiceImpl<SchemeDisplayMapper, SchemeDisplayEntity> {

  /**
   * 批量删除
   *
   * @param schemeCodes 方案编码集合
   * @param tenantCode  租户编码
   */
  public void updateDelFlagBySchemeCodes(List<String> schemeCodes, String tenantCode) {
    this.lambdaUpdate()
        .eq(SchemeDisplayEntity::getTenantCode, tenantCode)
        .in(SchemeDisplayEntity::getSchemeCode, schemeCodes)
        .set(SchemeDisplayEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param schemeCodes  方案编码集合
   * @param tenantCode   租户编码
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusBySchemeCodes(List<String> schemeCodes, EnableStatusEnum enableStatus, String tenantCode) {
    this.lambdaUpdate()
        .eq(SchemeDisplayEntity::getTenantCode, tenantCode)
        .in(SchemeDisplayEntity::getSchemeCode, schemeCodes)
        .set(SchemeDisplayEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 通过方案编码删除数据
   *
   * @param schemeCode 方案编码
   * @param tenantCode 租户编码
   */
  public void deleteBySchemeCode(String schemeCode, String tenantCode) {
    this.lambdaUpdate()
        .eq(SchemeDisplayEntity::getSchemeCode, schemeCode)
        .eq(SchemeDisplayEntity::getTenantCode, tenantCode)
        .remove();
  }

  /**
   * 多条件查询陈列方案列表
   *
   * @param model 条件model
   * @return 陈列方案列表
   */
  public List<SchemeDisplayEntity> findBySchemeDisplayConditionModel(SchemeDisplayConditionModel model) {
    return this.baseMapper.findBySchemeDisplayConditionModel(model);
  }
}
