package com.biz.crm.sfa.business.action.scheme.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeDisplayRequireEntity;
import com.biz.crm.sfa.business.action.scheme.local.mapper.SchemeDisplayRequireMapper;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 方案要求表的数据库访问类 {@link SchemeDisplayRequireEntity}
 *
 * @author ning.zhang
 * @date 2022-08-08 14:56:23
 */
@Component
public class SchemeDisplayRequireRepository extends ServiceImpl<SchemeDisplayRequireMapper, SchemeDisplayRequireEntity> {

  /**
   * 通过陈列方案ID删除数据
   *
   * @param displayIds 陈列方案ID
   */
  public void deleteByDisplayIds(Set<String> displayIds) {
    this.lambdaUpdate()
        .in(SchemeDisplayRequireEntity::getDisplayId, displayIds)
        .remove();
  }
}
