package com.biz.crm.sfa.business.action.scheme.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeFileEntity;
import com.biz.crm.sfa.business.action.scheme.local.mapper.SchemeFileMapper;
import org.springframework.stereotype.Component;

/**
 * 方案文件表的数据库访问类 {@link SchemeFileEntity}
 *
 * @author ning.zhang
 * @date 2022-08-05 14:32:19
 */
@Component
public class SchemeFileRepository extends ServiceImpl<SchemeFileMapper, SchemeFileEntity> {

  /**
   * 通过方案ID删除方案文件信息
   *
   * @param schemeId 方案ID
   */
  public void deleteBySchemeId(String schemeId) {
    this.lambdaUpdate()
        .eq(SchemeFileEntity::getSchemeId, schemeId)
        .remove();
  }
}
