package com.biz.crm.sfa.business.action.scheme.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeEntity;
import com.biz.crm.sfa.business.action.scheme.local.mapper.SchemeMapper;
import com.biz.crm.sfa.business.action.scheme.local.model.SchemeConditionModel;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemeActionSelectPageDto;
import com.biz.crm.sfa.business.action.scheme.sdk.dto.SchemePageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 方案表的数据库访问类 {@link SchemeEntity}
 *
 * @author ning.zhang
 * @date 2022-08-05 14:32:18
 */
@Component
public class SchemeRepository extends ServiceImpl<SchemeMapper, SchemeEntity> {

  /**
   * 多条件查询方案列表
   *
   * @param model 条件model
   * @return 方案列表
   */
  public List<SchemeEntity> findBySchemeConditionModel(SchemeConditionModel model) {
    return this.baseMapper.findBySchemeConditionModel(model);
  }

  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(SchemeEntity::getId, ids)
        .set(SchemeEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param ids          ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(SchemeEntity::getId, ids)
        .set(SchemeEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 方案分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SchemeEntity> 方案分页信息
   */
  public Page<SchemeEntity> findByConditions(Pageable pageable, SchemePageDto dto) {
    Page<SchemeEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 方案活动选择分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SchemeEntity> 方案分页信息
   */
  public Page<SchemeEntity> findBySchemeActionSelectPageDto(Pageable pageable, SchemeActionSelectPageDto dto) {
    Page<SchemeEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findBySchemeActionSelectPageDto(page, dto);
  }
}
