package com.biz.crm.sfa.business.action.scheme.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.action.scheme.local.entity.SchemeScopeEntity;
import com.biz.crm.sfa.business.action.scheme.local.mapper.SchemeScopeMapper;
import org.springframework.stereotype.Component;

/**
 * 方案范围表的数据库访问类 {@link SchemeScopeEntity}
 *
 * @author ning.zhang
 * @date 2022-08-05 14:32:19
 */
@Component
public class SchemeScopeRepository extends ServiceImpl<SchemeScopeMapper, SchemeScopeEntity> {

  /**
   * 通过方案ID删除方案范围信息
   *
   * @param schemeId 方案ID
   */
  public void deleteBySchemeId(String schemeId) {
    this.lambdaUpdate()
        .eq(SchemeScopeEntity::getSchemeId, schemeId)
        .remove();
  }
}
